#include <vector>
using namespace std;

typedef unsigned char UBYTE;
const int BITS_PER_ELEMENT=8;
#pragma comment(linker,"/stack:1024000000")
//const int L = 100000;
//const int C = 500;

class ItemBitmap
{
private:
	int support;
	vector<unsigned char> bitmap;
	vector<int> keyutil;

public:
	
	ItemBitmap(const unsigned int bits=0);
	ItemBitmap(const ItemBitmap &i);
	~ItemBitmap();
	ItemBitmap & operator = (const ItemBitmap & rhs);
	int intersect(ItemBitmap & rhs);

	int setBitSize(unsigned int nbits=0);
	int setBit(unsigned int i);
	int getBit(unsigned int i);
	int getSupport() {return support;};
	int countSupport();                                        //ǱЧ
	int countActualSupport(vector<int> &ItemProfit, vector<int> &new_closed, vector<int> &remap, vector< vector<int> > &itemcount);          //ʵЧõĺ
	//int xnor(ItemBitmap & rhs);
	int getKeyUtil(vector<int> &keyutil);                      //õЧ

	int isSubsetof(ItemBitmap &rhs);

	int nByte(unsigned int nbits) { return nbits/BITS_PER_ELEMENT+(nbits%BITS_PER_ELEMENT?1:0); }    
	int nElement() { return bitmap.size(); }
	int nBits() { return BITS_PER_ELEMENT * bitmap.size(); }

};
